%% compute the firing level of x on MF. MF is a trapezoidal MF defined by 4
%% parameters
%% Dongrui Wu, March 24, 2008

function f=firingLevel(x,MF)

if MF(1)==MF(2) %% left-shouder
    if x<=MF(3)
        f=1;
    elseif x>=MF(4)
        f=0;
    else
        f=(MF(4)-x)/(MF(4)-MF(3));
    end
elseif MF(3)==MF(4)  %% right-shoulder
    if x>=MF(2)
        f=1;
    elseif x<=MF(1)
        f=0;
    else
        f=(x-MF(1))/(MF(2)-MF(1));
    end
else  %% trapezoidal
    if x<=MF(1) | x>=MF(4)
        f=0;
    elseif x<=MF(2)
        f=(x-MF(1))/(MF(2)-MF(1));
    elseif x>=MF(3)
        f=(MF(4)-x)/(MF(4)-MF(3));
    else
        f=1;
    end
end